/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.LOTRAchievement;
import lotr.common.LOTRCapes;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIGandalfSmoke;
import lotr.common.entity.ai.LOTREntityAINearestAttackableTargetBasic;
import lotr.common.entity.npc.LOTREntityBalrog;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntitySaruman;
import lotr.common.entity.npc.LOTRNames;
import lotr.common.entity.npc.LOTRTradeEntries;
import lotr.common.entity.npc.LOTRTravellingTrader;
import lotr.common.fac.LOTRFaction;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class LOTREntityRadaghast
extends LOTREntityNPC
implements LOTRTravellingTrader {
    public LOTREntityRadaghast(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75498_b(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIAttackOnCollide(this, 1.8, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new LOTREntityAIGandalfSmoke(this, 3000));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 8.0f, 0.05f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 5.0f, 0.05f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        int target = this.addTargetTasks(false);
        this.field_70715_bh.func_75776_a(target + 1, (EntityAIBase)new LOTREntityAINearestAttackableTargetBasic(this, LOTREntityBalrog.class, 0, true));
        this.field_70715_bh.func_75776_a(target + 2, (EntityAIBase)new LOTREntityAINearestAttackableTargetBasic(this, LOTREntitySaruman.class, 0, true));
        this.npcCape = LOTRCapes.RADAGHAST;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
    }

    @Override
    public void setupNPCGender() {
        this.familyInfo.setMale(true);
    }

    @Override
    public void setupNPCName() {
        this.familyInfo.setName(LOTRNames.getBrownMagName(this.field_70146_Z, this.familyInfo.isMale()));
    }

    @Override
    public String getNPCName() {
        return this.familyInfo.getName();
    }

    @Override
    public float getAlignmentBonus() {
        return 0.0f;
    }

    @Override
    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        data = super.func_110161_a(data);
        this.npcItemsInv.setMeleeWeapon(new ItemStack(LOTRMod.daggerWoodElvenPoisoned));
        this.npcItemsInv.setIdleItem(new ItemStack(LOTRMod.radaghaststaff));
        this.func_70062_b(1, new ItemStack(LOTRMod.radagasthat));
        this.func_70062_b(2, new ItemStack(LOTRMod.radagastlegs));
        this.func_70062_b(3, new ItemStack(LOTRMod.radagastbody));
        this.func_70062_b(4, new ItemStack(LOTRMod.radagastboots));
        return data;
    }

    @Override
    public void onAttackModeChange(LOTREntityNPC.AttackMode mode, boolean mounted) {
        if (mode == LOTREntityNPC.AttackMode.IDLE) {
            this.func_70062_b(0, this.npcItemsInv.getIdleItem());
        } else {
            this.func_70062_b(0, this.npcItemsInv.getMeleeWeapon());
        }
    }

    @Override
    public ItemStack getHeldItemLeft() {
        ItemStack heldItem = this.func_70694_bm();
        if (heldItem != null && heldItem.func_77973_b() == LOTRMod.daggerWoodElvenPoisoned) {
            return new ItemStack(LOTRMod.radaghaststaff);
        }
        return super.getHeldItemLeft();
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.UNALIGNED;
    }

    @Override
    public boolean canBeFreelyTargetedBy(EntityLiving attacker) {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float f) {
        Entity entity = damagesource.func_76346_g();
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return super.func_70097_a(damagesource, f);
        }
        f = 0.0f;
        return super.func_70097_a(damagesource, f);
    }

    private void doGandalfFX() {
        this.func_85030_a("random.pop", 2.0f, 0.5f + this.field_70146_Z.nextFloat() * 0.5f);
        this.field_70170_p.func_72960_a((Entity)this, (byte)16);
    }

    @Override
    public boolean canTradeWith(EntityPlayer entityplayer) {
        return LOTRLevelData.getData(entityplayer).getAlignment(this.getFaction()) >= 0.0f && this.isFriendly(entityplayer);
    }

    @Override
    public void onPlayerTrade(EntityPlayer entityplayer, LOTRTradeEntries.TradeType type, ItemStack itemstack) {
        LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.tradeRadaghast);
        if (type == LOTRTradeEntries.TradeType.SELL && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150337_Q) && itemstack.func_77960_j() == 0) {
            LOTRLevelData.getData(entityplayer).addAchievement(LOTRAchievement.sellMushroom);
        }
    }

    @Override
    public String getSpeechBank(EntityPlayer entityplayer) {
        if (this.isFriendlyAndAligned(entityplayer)) {
            return "char/radaghast/friendly";
        }
        return "char/radaghast/hostile";
    }

    @Override
    public LOTRTradeEntries getBuyPool() {
        return LOTRTradeEntries.RADAGHAST_TRADER_BUY;
    }

    @Override
    public LOTRTradeEntries getSellPool() {
        return LOTRTradeEntries.RADAGHAST_TRADER_SELL;
    }

    @Override
    public boolean shouldTraderRespawn() {
        return false;
    }

    @Override
    public LOTREntityNPC createTravellingEscort() {
        return null;
    }

    @Override
    public String getDepartureSpeech() {
        return "char/radaghast/depart";
    }
}

